IF  EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].UFD_EST_PROD_TRIB') AND TYPE IN (N'FN', N'IF', N'TF', N'FS', N'FT'))
    DROP FUNCTION [DBO].UFD_EST_PROD_TRIB
GO 
/*
=======================================================================================
'Nvel Classificao.: INFORMAO RESTRITA
'Verso..............: 20240322
'Job.................:  
'Nome................: UFD_EST_PROD_TRIB
'Objetivo............: 
'Tabelas.............: 
'Dt Criao..........: --
'Dt Ult Alteraco....: 22/03/2024
'Criado por..........: --
'Versionado por......: Marcos Barros
'Alterado por........: 
'=======================================================================================
*/


CREATE FUNCTION [dbo].[UFD_EST_PROD_TRIB](  @CD_EMP                 INT,
                                            @CD_FILIAL              INT,
                                            @CD_MOV_OP              INT,
                                            @CD_DEST_ORIG           INT,
                                            @CD_PROD                VARCHAR(MAX),
                                            @GERA_DARE              INT,
                                            @TP_MOV                 INT,
                                            @TP_MOV_OP_TRANSA       INT,
                                            @QT_PROD                MONEY,
                                            @VLR_IT                 MONEY,
                                            @PERC_DESC_IT           MONEY,
                                            @PERC_IPI               MONEY,
                                            @VLR_FRETE              MONEY,
                                            @VLR_OUTRAS             MONEY,
                                            @TIPO_OPERACAO          INT,
                                            @ALIQ_ICMS_ENTRADA      MONEY)

RETURNS @RS_RETURN TABLE(
							CD_ID                                  INT,    
                            CD_EMP                              INT,
                            CD_PROD                             INT,    
                            CD_CTR                              INT,    
                            CD_TRIB_CST                         INT,
                            UF                                  VARCHAR(2),
                            UF_FILIAL                           VARCHAR(2),
                            TP_MOV                              INT,
                            TP_TRANSA                           INT,
                            TP_LISTA                            INT,
                            DS_TP_LISTA                         VARCHAR(20),
                            NR_NCM                              VARCHAR(50) ,
                            NR_CEST                             VARCHAR(20),
                            CD_CLASS_FISC                       INT,
                            DS_CLASS_FISC                       VARCHAR(200),
                            PERC_RED                            MONEY ,
                            PERC_ICMS                           MONEY,
                            TP_RED_BASE_IMP                     MONEY ,
                            PERC_RED_SUBS_TRIB                  MONEY ,
                            PERC_RED_ESTORNO                    MONEY ,
                            PERC_REPASSE                        MONEY ,
                            PERC_IBPT                           MONEY,
                            TP_GERACAO_DARE                     INT,
                            FLAG_TRIB_DARE                      INT,
                            VLR_PAUTA_IVA                       MONEY,
                            TP_SUBS                             INT,
                            DS_TP_SUBS                          VARCHAR(100),    
                            PERC_ICMS_EST                       MONEY,
                            PERC_ICMS_ORIGEM                    MONEY,
                            HIST                                VARCHAR(500),
                            CD_TRIB                             INT,
                            CD_TRIB_FC                          VARCHAR(5),
                            ICMS                                INT,
                            SUBS_TRIB                           INT,
                            ICMS_RD                             INT,
                            SUBS_TRIB_ANT                       INT,
                            ISENTO                              INT,
                            TIPO_REGIME_EMPRESA                 INT,
                            FLAG_VLR_SUBST_TOTAL_PROD           INT, 
                            FLAG_GERAR_ICMS_SUBS_DARE           INT, 
                            FLAG_OUTROS                         INT,
                            ORIGEM_PRODUTO                      INT,
                            DS_ORIGEM_PRODUTO                   VARCHAR(500),
                            CD_TBL_MVA                          INT,
                            CD_REGIAO_FISCAL                    INT,
                            NM_REGIAO_FISCAL                    VARCHAR(200),
                            VLR_PAUTA_IVA_ORIGINAL              MONEY,
                            MVA_AJUSTADO                        INT,
                            TIPO_TRIBUTACAO_PIS_COFINS          INT,
                            SIGLA_EXCECAO_PIS_COFINS            VARCHAR(10),
                            FLAG_EXCECAO_PIS_COFINS             INT,
                            PIS_COFINS                          INT,
                            FLAG_NAO_TRIBUTAR_PIS_COFINS_MOV_OP INT,
                            FLAG_TRIB_PIS_COFINS_PROD           INT,
                            CTR_PMC                             INT,
                            FLAG_GERAR_ICMS_RETIDO              INT,
                            PERC_RED_IMPORTADO                  MONEY,
                            PERC_RED_SUBS_TRIB_IMPORTADO        MONEY,
                            TIPO_REGIME_EMPRESA_GRUPO_TRIB      INT,
                            DS_TIPO_REGIME_EMPRESA_GRUPO_TRIB   VARCHAR(100),
                            TIPO_REGIME_DESTINATARIO_ORIGEM     INT,
                            DS_TIPO_REGIME_DESTINATARIO_ORIGEM  VARCHAR(100),
                            OBS_GRUPO_TRIB_NF                   VARCHAR(200),
                            EXCECAO_MVA_PRODUTO                 INT,
                            MODALI_BASE_ICMS_SUBST              INT,
                            DS_MODALI_BASE_ICMS_SUBST           VARCHAR(200),
                            PRECO_BASE_SUBS                     INT,
                            PERC_REDU_PMC_FORN                  MONEY,
                            TIPO_REGIME_FILIAL                  INT,
                            DS_TIPO_REGIME_FILIAL               VARCHAR(200),
                            TRIBUTACAO_FORNECEDOR               VARCHAR(3),
                            VLR_PMC                             MONEY,
                            VLR_ICMS_SUBS_GARANTIR              MONEY,
                            PERC_ICMS_DESTINO_DIFAL             MONEY,
                            PERC_ICMS_ORIGEM_DIFAL              MONEY, 
                            GERAR_DIFAL                         INT,
                            GERAR_DAR                           INT,
                            CONTRIBUINTE                        INT,
                            FLAG_GERAR_MOV_DARE                 INT,
                            GERAR_SUBS_TRIB                     INT,
                            TP_SUBS_TRIB                        INT,
                            PERC_ALIQ_FECOP                     MONEY,
                            FLAG_FRETE_BASE_ICMS                MONEY,
                            FCOP                                INT,
                            ICMS_DESONERADO                     INT,
                            MOTIVO_DESONERADO_ICMS              INT,
                            VLR_ICMS_DESONERADO                 MONEY,
                            PERC_ICMS_DESONERADO                MONEY,
                            CD_BENEF                            VARCHAR(10) ,
                            QT_PROD                             INT, -- RETORNO APARTIR DOS APPLY
                            VLR_IT                              MONEY,
                            VLR_DESC_IT                         MONEY,
                            VLR_FRETE                           MONEY,
                            VLR_OUTROS                          MONEY,
                            VLR_IPI                             MONEY,
                            VLR_BASE_ICMS                       MONEY,
                            VLR_ICMS                            MONEY,    
                            VLR_BASE_SUBS                       MONEY,    
                            VLR_ICMS_SUBS                       MONEY,
                            VLR_BASE_ICMS_OP                    MONEY,
                            VLR_ICMS_OP                         MONEY,
                            VLR_BASE_RET                        MONEY,
                            VLR_ICMS_RET                        MONEY,
                            VLR_CUSTO                           MONEY,
                            VLR_REA                             MONEY,
                            VLR_BASE_FECOP                      MONEY,
                            VLR_BASE_FECOP_SUBS                 MONEY,
                            VLR_BASE_FECOP_RET                  MONEY,
                            VLR_FECOP                           MONEY,
                            VLR_FECOP_ST                        MONEY,
                            VLR_FECOP_RET                       MONEY    ,
                            CD_NT_OP                            INT,
                            CD_NT_OP_FC                         VARCHAR(10),
                            CST_PIS                             INT,
                            PERC_PIS                            MONEY,
                            VLR_BASE_PIS                        MONEY,
                            VLR_PIS                             MONEY,
                            CST_COFINS                          INT,
                            PERC_COFINS                         MONEY,
                            VLR_BASE_COFINS                     MONEY,
                            VLR_COFINS                          MONEY,
                            MOV_FLAG_NAO_TRIBUTAR_PIS_COFINS    INT,
                            PROD_PIS_COFINS                     INT,
                            PROD_TIPO_TRIBUTACAO_PIS_COFINS     INT,
                            PROD_FLAG_TRIB_PIS_COFINS_PROD      INT,
                            PROD_LISTA_PROD                     INT,
                            NT_OP_CST                           INT, 
                            CST_TP_TRIB_PIS                     INT,
                            CST_TP_TRIB_COFINS                  INT,
                            PERC_DIFERIMENTO                    MONEY,
							VLR_DIFERIMENTO                     MONEY,
							CD_PROC_FISCAL_REFERENCIADO			INT,
							GERAR_DARE_FECOP_ST					INT,
							SUBS_TRIB_FECOP_ST					INT,
                            TP_SUBS_TRIB_FECOP_ST               INT,
							INSC_SUFRAMA						VARCHAR(20),
							ALIQ_EFET_ICMS						MONEY,
							PERC_EFET_RED_BASE_CALC				MONEY,
							VLR_EFET_BASE_ICMS					MONEY,
							VLR_EFET_ICMS						MONEY,
							FLAG_ICMS_ANTECIPADO				INT,
							CD_TRIB_CST_ORIGINAL				INT,
							VLR_DESC_FINAN						MONEY,
							VLR_CUSTO_SEM_ST					MONEY,
							VLR_CUSTO_GER						MONEY,
							VLR_CUSTO_ANT_RECALC				MONEY,
							VLR_CUSTO_ANT						MONEY,
							ALIQ_ICMS_INTERNO					MONEY,
							VLR_ICMS_SUBSTITUTO					MONEY,
							FLAG_VLR_ICMS_DESONERADO_DESCONTO	INT,
							DS_MOTIVO_DESONERADO 	VARCHAR(500),
							PERC_ALIQ_FECOP_ST					MONEY,
							CD_BENEF_RED                            VARCHAR(10),
							BASE_ICMS_DESTINO_DIFAL			DECIMAL(18,4),
							VALOR_ICMS_DESTINO_DIFAL		DECIMAL(18,4)
							)

AS
BEGIN
        
	INSERT INTO
		@RS_RETURN (
			CD_ID
			,CD_EMP
			,CD_PROD
			,CD_CTR
			,CD_TRIB_CST
			,UF
			,UF_FILIAL
			,TP_MOV
			,TP_TRANSA
			,TP_LISTA
			,DS_TP_LISTA
			,NR_NCM
			,NR_CEST
			,CD_CLASS_FISC
			,DS_CLASS_FISC
			,PERC_RED
			,PERC_ICMS
			,TP_RED_BASE_IMP
			,PERC_RED_SUBS_TRIB
			,PERC_RED_ESTORNO
			,PERC_REPASSE
			,PERC_IBPT
			,TP_GERACAO_DARE
			,FLAG_TRIB_DARE
			,VLR_PAUTA_IVA
			,TP_SUBS
			,DS_TP_SUBS
			,PERC_ICMS_EST
			,PERC_ICMS_ORIGEM
			,HIST
			,CD_TRIB
			,CD_TRIB_FC
			,ICMS
			,SUBS_TRIB
			,ICMS_RD
			,SUBS_TRIB_ANT
			,ISENTO
			,TIPO_REGIME_EMPRESA
			,FLAG_VLR_SUBST_TOTAL_PROD
			,FLAG_GERAR_ICMS_SUBS_DARE
			,FLAG_OUTROS
			,ORIGEM_PRODUTO
			,DS_ORIGEM_PRODUTO
			,CD_TBL_MVA
			,CD_REGIAO_FISCAL
			,NM_REGIAO_FISCAL
			,VLR_PAUTA_IVA_ORIGINAL
			,MVA_AJUSTADO
			,TIPO_TRIBUTACAO_PIS_COFINS
			,SIGLA_EXCECAO_PIS_COFINS
			,FLAG_EXCECAO_PIS_COFINS
			,PIS_COFINS
			,FLAG_NAO_TRIBUTAR_PIS_COFINS_MOV_OP
			,FLAG_TRIB_PIS_COFINS_PROD
			,CTR_PMC
			,FLAG_GERAR_ICMS_RETIDO
			,PERC_RED_IMPORTADO
			,PERC_RED_SUBS_TRIB_IMPORTADO
			,TIPO_REGIME_EMPRESA_GRUPO_TRIB
			,DS_TIPO_REGIME_EMPRESA_GRUPO_TRIB
			,TIPO_REGIME_DESTINATARIO_ORIGEM
			,DS_TIPO_REGIME_DESTINATARIO_ORIGEM
			,OBS_GRUPO_TRIB_NF
			,EXCECAO_MVA_PRODUTO
			,MODALI_BASE_ICMS_SUBST
			,DS_MODALI_BASE_ICMS_SUBST
			,PRECO_BASE_SUBS
			,PERC_REDU_PMC_FORN
			,TIPO_REGIME_FILIAL
			,DS_TIPO_REGIME_FILIAL
			,TRIBUTACAO_FORNECEDOR
			,VLR_PMC
			,VLR_ICMS_SUBS_GARANTIR
			,PERC_ICMS_DESTINO_DIFAL
			,PERC_ICMS_ORIGEM_DIFAL
			,GERAR_DIFAL
			,GERAR_DAR
			,CONTRIBUINTE
			,FLAG_GERAR_MOV_DARE
			,GERAR_SUBS_TRIB
			,TP_SUBS_TRIB
			,PERC_ALIQ_FECOP
			,FLAG_FRETE_BASE_ICMS
			,FCOP
			,ICMS_DESONERADO
			,MOTIVO_DESONERADO_ICMS
			,VLR_ICMS_DESONERADO
			,PERC_ICMS_DESONERADO
			,CD_BENEF
			,QT_PROD
			,VLR_IT
			,VLR_DESC_IT
			,VLR_FRETE
			,VLR_OUTROS
			,VLR_IPI
			,VLR_BASE_ICMS
			,VLR_ICMS
			,VLR_BASE_SUBS
			,VLR_ICMS_SUBS
			,VLR_BASE_ICMS_OP
			,VLR_ICMS_OP
			,VLR_BASE_RET
			,VLR_ICMS_RET
			,VLR_CUSTO
			,VLR_REA
			,VLR_BASE_FECOP
			,VLR_BASE_FECOP_SUBS
			,VLR_BASE_FECOP_RET
			,VLR_FECOP
			,VLR_FECOP_ST
			,VLR_FECOP_RET
			,CD_NT_OP
			,CD_NT_OP_FC
			,CST_PIS
			,PERC_PIS
			,VLR_BASE_PIS
			,VLR_PIS
			,CST_COFINS
			,PERC_COFINS
			,VLR_BASE_COFINS
			,VLR_COFINS
			,MOV_FLAG_NAO_TRIBUTAR_PIS_COFINS
			,PROD_PIS_COFINS
			,PROD_TIPO_TRIBUTACAO_PIS_COFINS
			,PROD_FLAG_TRIB_PIS_COFINS_PROD
			,PROD_LISTA_PROD
			,NT_OP_CST
			,CST_TP_TRIB_PIS
			,CST_TP_TRIB_COFINS
			,PERC_DIFERIMENTO
			,VLR_DIFERIMENTO
			,CD_PROC_FISCAL_REFERENCIADO			
			,GERAR_DARE_FECOP_ST					
			,SUBS_TRIB_FECOP_ST					
			,TP_SUBS_TRIB_FECOP_ST
			,INSC_SUFRAMA		
			,ALIQ_EFET_ICMS			
			,PERC_EFET_RED_BASE_CALC	
			,VLR_EFET_BASE_ICMS		
			,VLR_EFET_ICMS			
			,FLAG_ICMS_ANTECIPADO	
			,CD_TRIB_CST_ORIGINAL
			,VLR_DESC_FINAN
			,VLR_CUSTO_SEM_ST
			,VLR_CUSTO_GER
			,VLR_CUSTO_ANT_RECALC
			,VLR_CUSTO_ANT
			,ALIQ_ICMS_INTERNO
			,VLR_ICMS_SUBSTITUTO
			,FLAG_VLR_ICMS_DESONERADO_DESCONTO
			,DS_MOTIVO_DESONERADO
			,PERC_ALIQ_FECOP_ST
			,CD_BENEF_RED
			,BASE_ICMS_DESTINO_DIFAL
			,VALOR_ICMS_DESTINO_DIFAL)	


	SELECT
		CD_ID
		,CD_EMP
		,CD_PROD
		,CD_CTR
		,CD_TRIB_CST
		,UF
		,UF_FILIAL
		,TP_MOV
		,TP_TRANSA
		,TP_LISTA
		,DS_TP_LISTA
		,NR_NCM
		,NR_CEST
		,CD_CLASS_FISC
		,DS_CLASS_FISC
		,PERC_RED
		,PERC_ICMS
		,TP_RED_BASE_IMP
		,PERC_RED_SUBS_TRIB
		,PERC_RED_ESTORNO
		,PERC_REPASSE
		,PERC_IBPT
		,TP_GERACAO_DARE
		,FLAG_TRIB_DARE
		,VLR_PAUTA_IVA
		,TP_SUBS
		,DS_TP_SUBS
		,PERC_ICMS_EST
		,PERC_ICMS_ORIGEM
		,HIST
		,CD_TRIB
		,CD_TRIB_FC
		,ICMS
		,SUBS_TRIB
		,ICMS_RD
		,SUBS_TRIB_ANT
		,ISENTO
		,TIPO_REGIME_EMPRESA
		,FLAG_VLR_SUBST_TOTAL_PROD
		,FLAG_GERAR_ICMS_SUBS_DARE
		,FLAG_OUTROS
		,ORIGEM_PRODUTO
		,DS_ORIGEM_PRODUTO
		,CD_TBL_MVA
		,CD_REGIAO_FISCAL
		,NM_REGIAO_FISCAL
		,VLR_PAUTA_IVA_ORIGINAL
		,MVA_AJUSTADO
		,TIPO_TRIBUTACAO_PIS_COFINS
		,SIGLA_EXCECAO_PIS_COFINS
		,FLAG_EXCECAO_PIS_COFINS
		,PIS_COFINS
		,FLAG_NAO_TRIBUTAR_PIS_COFINS_MOV_OP
		,FLAG_TRIB_PIS_COFINS_PROD
		,CTR_PMC
		,FLAG_GERAR_ICMS_RETIDO
		,PERC_RED_IMPORTADO
		,PERC_RED_SUBS_TRIB_IMPORTADO
		,TIPO_REGIME_EMPRESA_GRUPO_TRIB
		,DS_TIPO_REGIME_EMPRESA_GRUPO_TRIB
		,TIPO_REGIME_DESTINATARIO_ORIGEM
		,DS_TIPO_REGIME_DESTINATARIO_ORIGEM
		,OBS_GRUPO_TRIB_NF
		,EXCECAO_MVA_PRODUTO
		,MODALI_BASE_ICMS_SUBST
		,DS_MODALI_BASE_ICMS_SUBST
		,PRECO_BASE_SUBS
		,PERC_REDU_PMC_FORN
		,TIPO_REGIME_FILIAL
		,DS_TIPO_REGIME_FILIAL
		,TRIBUTACAO_FORNECEDOR
		,VLR_PMC
		,VLR_ICMS_SUBS_GARANTIR
		,PERC_ICMS_DESTINO_DIFAL
		,PERC_ICMS_ORIGEM_DIFAL
		,GERAR_DIFAL
		,GERAR_DAR
		,CONTRIBUINTE
		,FLAG_GERAR_MOV_DARE
		,GERAR_SUBS_TRIB
		,TP_SUBS_TRIB
		,PERC_ALIQ_FECOP
		,FLAG_FRETE_BASE_ICMS
		,FCOP
		,ICMS_DESONERADO
		,MOTIVO_DESONERADO_ICMS
		,VLR_ICMS_DESONERADO
		,PERC_ICMS_DESONERADO
		,CD_BENEF
		,QT_PROD
		,VLR_IT
		,VLR_DESC_IT
		,VLR_FRETE
		,VLR_OUTROS
		,VLR_IPI
		,VLR_BASE_ICMS
		,VLR_ICMS
		,VLR_BASE_SUBS
		,VLR_ICMS_SUBS
		,VLR_BASE_ICMS_OP
		,VLR_ICMS_OP
		,VLR_BASE_RET
		,VLR_ICMS_RET
		,VLR_CUSTO
		,VLR_REA
		,VLR_BASE_FECOP
		,VLR_BASE_FECOP_SUBS
		,VLR_BASE_FECOP_RET
		,VLR_FECOP
		,VLR_FECOP_ST
		,VLR_FECOP_RET
		,CD_NT_OP
		,CD_NT_OP_FC
		,CST_PIS
		,PERC_PIS
		,VLR_BASE_PIS
		,VLR_PIS
		,CST_COFINS
		,PERC_COFINS
		,VLR_BASE_COFINS
		,VLR_COFINS
		,MOV_FLAG_NAO_TRIBUTAR_PIS_COFINS
		,PROD_PIS_COFINS
		,PROD_TIPO_TRIBUTACAO_PIS_COFINS
		,PROD_FLAG_TRIB_PIS_COFINS_PROD
		,PROD_LISTA_PROD
		,NT_OP_CST
		,CST_TP_TRIB_PIS
		,CST_TP_TRIB_COFINS
		,PERC_DIFERIMENTO
		,VLR_DIFERIMENTO
		,CD_PROC_FISCAL_REFERENCIADO			
		,GERAR_DARE_FECOP_ST					
		,SUBS_TRIB_FECOP_ST					
		,TP_SUBS_TRIB_FECOP_ST
		,INSC_SUFRAMA		
		,ALIQ_EFET_ICMS			
		,PERC_EFET_RED_BASE_CALC	
		,VLR_EFET_BASE_ICMS		
		,VLR_EFET_ICMS			
		,FLAG_ICMS_ANTECIPADO	
		,CD_TRIB_CST_ORIGINAL
		,VLR_DESC_FINAN
		,VLR_CUSTO_SEM_ST
		,VLR_CUSTO_GER
		,VLR_CUSTO_ANT_RECALC
		,VLR_CUSTO_ANT
		,ALIQ_ICMS_INTERNO
		,VLR_ICMS_SUBSTITUTO
		,FLAG_VLR_ICMS_DESONERADO_DESCONTO
		,ISNULL(DS_MOTIVO_DESONERADO,'') AS DS_MOTIVO_DESONERADO
		,PERC_ALIQ_FECOP_ST
		,CD_BENEF_RED
		,BASE_ICMS_DESTINO_DIFAL
		,VALOR_ICMS_DESTINO_DIFAL
		FROM
		UFD_EST_PROD_TRIB_UF (@CD_EMP
							,@CD_FILIAL
							,@CD_MOV_OP
							,@CD_DEST_ORIG
							,@CD_PROD
							,@GERA_DARE
							,@TP_MOV
							,@TP_MOV_OP_TRANSA
							,@QT_PROD
							,@VLR_IT
							,@PERC_DESC_IT
							,@PERC_IPI
							,@VLR_FRETE
							,@VLR_OUTRAS
							,@TIPO_OPERACAO
							,@ALIQ_ICMS_ENTRADA
							,'')
    RETURN     
END
GO


